import{Fragment,h}from"@stencil/core";import{sprintf,__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{productNameWithPrice}from"../../../../functions/price";export class ScSubscription{constructor(){this.subscriptionId=void 0,this.showCancel=void 0,this.heading=void 0,this.query=void 0,this.protocol=void 0,this.subscription=void 0,this.updatePaymentMethodUrl=void 0,this.loading=void 0,this.cancelModal=void 0,this.resubscribeModal=void 0,this.busy=void 0,this.error=void 0}componentWillLoad(){onFirstVisible(this.el,(()=>{this.subscription||this.getSubscription()}))}async cancelPendingUpdate(){var e;if(confirm(__("Are you sure you want to cancel the pending update to your plan?","surecart")))try{this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(e=this.subscription)||void 0===e?void 0:e.id}/`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH",data:{purge_pending_update:!0}})}catch(e){(null==e?void 0:e.message)?this.error=e.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.busy=!1}}async renewSubscription(){var e;try{this.error="",this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(e=this.subscription)||void 0===e?void 0:e.id}/renew`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH"})}catch(e){this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getSubscription(){var e;try{this.loading=!0,this.subscription=await await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${this.subscriptionId||(null===(e=this.subscription)||void 0===e?void 0:e.id)}`,{expand:["price","price.product","current_period"],...this.query||{}})})}catch(e){(null==e?void 0:e.message)?this.error=e.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.loading=!1}}renderName(e){var t;return"string"!=typeof(null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product)?productNameWithPrice(null==e?void 0:e.price):__("Subscription","surecart")}renderRenewalText(e){const t=h("sc-subscription-status-badge",{subscription:e});return(null==e?void 0:e.cancel_at_period_end)&&e.current_period_end_at?h("span",null,t," "," ",
/* translators: %s: current period end date */
sprintf(__("Your plan will be canceled on %s","surecart"),e.current_period_end_at_date)):"trialing"===e.status&&e.trial_end_at?h("span",null,t," "," ",
/* translators: %s: trial end date */
sprintf(__("Your plan begins on %s","surecart"),e.trial_end_at_date)):"active"===e.status&&e.current_period_end_at?h("span",null,t," "," ",
/* translators: %s: current period end date */
sprintf(__("Your plan renews on %s","surecart"),e.current_period_end_at_date)):t}renderEmpty(){return h("slot",{name:"empty"},__("This subscription does not exist.","surecart"))}renderLoading(){return h("sc-stacked-list-row",{style:{"--columns":"2"},"mobile-size":0},h("div",{style:{padding:"0.5em"}},h("sc-skeleton",{style:{width:"30%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"20%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"40%"}})))}renderContent(){return this.loading?this.renderLoading():this.subscription?h(Fragment,null,h("sc-subscription-next-payment",{subscription:this.subscription,updatePaymentMethodUrl:this.updatePaymentMethodUrl},h("sc-subscription-details",{subscription:this.subscription}))):this.renderEmpty()}render(){var e,t,i,s,r,o,n;const c=(null==this?void 0:this.subscription.payment_method)||(null==this?void 0:this.subscription.manual_payment);return h("sc-dashboard-module",{key:"5b923a5556913f8d3a8fdccefe9e228a99dfb732",heading:this.heading||__("Current Plan","surecart"),class:"subscription",error:this.error},!!this.subscription&&h("sc-flex",{key:"9ca0e38dcb9467129def9cbae6bdc8e7ea220a39",slot:"end",class:"subscription__action-buttons"},this.updatePaymentMethodUrl&&c&&h("sc-button",{key:"1ba00ba4ac94214f68fa95e79c3ac328ede2d00c",type:"link",href:this.updatePaymentMethodUrl},h("sc-icon",{key:"16ba4fe6c966957aea3317f39086048b57803eff",name:"credit-card",slot:"prefix"}),__("Update Payment Method","surecart")),!c&&h("sc-button",{key:"c94a95c93b9a8c9c1a62178ef2c7d6833b6f44b1",type:"link",href:addQueryArgs(window.location.href,{action:"create",model:"payment_method",id:null==this?void 0:this.subscription.id,...!1===(null===(e=null==this?void 0:this.subscription)||void 0===e?void 0:e.live_mode)?{live_mode:!1}:{}})},h("sc-icon",{key:"7e2fe44f68087dc8a2f317b8f8b1bf51323a87b0",name:"credit-card",slot:"prefix"}),__("Add Payment Method","surecart")),!!Object.keys(null===(t=this.subscription)||void 0===t?void 0:t.pending_update).length&&h("sc-button",{key:"e0b4d8f7fbd2c06897bd956b743e3bf0256d5065",type:"link",onClick:()=>this.cancelPendingUpdate()},h("sc-icon",{key:"950d7473bf6feebbf3d59cd5b268c6187d9229f7",name:"x-octagon",slot:"prefix"}),__("Cancel Scheduled Update","surecart")),(null===(i=null==this?void 0:this.subscription)||void 0===i?void 0:i.cancel_at_period_end)?h("sc-button",{type:"link",onClick:()=>this.renewSubscription()},h("sc-icon",{name:"repeat",slot:"prefix"}),__("Restore Plan","surecart")):"canceled"!==(null===(s=this.subscription)||void 0===s?void 0:s.status)&&(null===(r=this.subscription)||void 0===r?void 0:r.current_period_end_at)&&this.showCancel&&h("sc-button",{type:"link",onClick:()=>this.cancelModal=!0},h("sc-icon",{name:"x",slot:"prefix"}),__("Cancel Plan","surecart")),"canceled"===(null===(o=this.subscription)||void 0===o?void 0:o.status)&&h("sc-button",{key:"41110e9c9a7d2c1ce1061bc9fbf4d5607e6cdbda",type:"link",...(null===(n=this.subscription)||void 0===n?void 0:n.payment_method)?{onClick:()=>this.resubscribeModal=!0}:{href:null==this?void 0:this.updatePaymentMethodUrl}},h("sc-icon",{key:"65b2400d753646910854d38cb726263b6c30d345",name:"repeat",slot:"prefix"}),__("Resubscribe","surecart"))),h("sc-card",{key:"51bc142a5b7215112ae362fd0a3fcaa747835a21",style:{"--overflow":"hidden"},noPadding:!0},this.renderContent()),this.busy&&h("sc-block-ui",{key:"8c94cd3200d9f1f46fc43e049570e0614281c34e",spinner:!0}),h("sc-cancel-dialog",{key:"171540a20abbb135b2eae1d74d83b20831bdca6f",subscription:this.subscription,protocol:this.protocol,open:this.cancelModal,onScRequestClose:()=>this.cancelModal=!1,onScRefresh:()=>this.getSubscription()}),h("sc-subscription-reactivate",{key:"e17ebc78c1ed1c5c1bde1140a306626d64f55f3f",subscription:this.subscription,open:this.resubscribeModal,onScRequestClose:()=>this.resubscribeModal=!1,onScRefresh:()=>this.getSubscription()}))}static get is(){return"sc-subscription"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-subscription.scss"]}}static get styleUrls(){return{$:["sc-subscription.css"]}}static get properties(){return{subscriptionId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The subscription ID"},attribute:"subscription-id",reflect:!1},showCancel:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether to show the cancel button"},attribute:"show-cancel",reflect:!1},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Heading to display"},attribute:"heading",reflect:!1},query:{type:"unknown",mutable:!1,complexType:{original:"object",resolved:"object",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Query to pass to the API"}},protocol:{type:"unknown",mutable:!1,complexType:{original:"SubscriptionProtocol",resolved:"SubscriptionProtocol",references:{SubscriptionProtocol:{location:"import",path:"../../../../types",id:"src/types.ts::SubscriptionProtocol"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription protocol"}},subscription:{type:"unknown",mutable:!0,complexType:{original:"Subscription",resolved:"Subscription",references:{Subscription:{location:"import",path:"../../../../types",id:"src/types.ts::Subscription"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription"}},updatePaymentMethodUrl:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Update the payment method url"},attribute:"update-payment-method-url",reflect:!1}}}static get states(){return{loading:{},cancelModal:{},resubscribeModal:{},busy:{},error:{}}}static get elementRef(){return"el"}}